/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.renderlayers;

import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.accessor.PlayerEntityModelAccessor;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.render.CustomizableModelPart;
import dev.tr7zw.skinlayers.render.SolidPixelWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1664;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_922;

public class BodyLayerFeatureRenderer
extends class_3887<class_742, class_591<class_742>> {
    private final boolean thinArms;
    private static final class_310 mc = class_310.method_1551();
    private final List<Layer> bodyLayers = new ArrayList<Layer>();

    public BodyLayerFeatureRenderer(class_3883<class_742, class_591<class_742>> renderLayerParent) {
        super(renderLayerParent);
        this.thinArms = ((PlayerEntityModelAccessor)this.method_17165()).hasThinArms();
        this.bodyLayers.add(new Layer(0, false, class_1664.field_7566, Shape.LEGS, () -> ((class_591)this.method_17165()).field_3397, () -> SkinLayersModBase.config.enableLeftPants));
        this.bodyLayers.add(new Layer(1, false, class_1664.field_7565, Shape.LEGS, () -> ((class_591)this.method_17165()).field_3392, () -> SkinLayersModBase.config.enableRightPants));
        this.bodyLayers.add(new Layer(2, false, class_1664.field_7568, this.thinArms ? Shape.ARMS_SLIM : Shape.ARMS, () -> ((class_591)this.method_17165()).field_27433, () -> SkinLayersModBase.config.enableLeftSleeve));
        this.bodyLayers.add(new Layer(3, true, class_1664.field_7570, this.thinArms ? Shape.ARMS_SLIM : Shape.ARMS, () -> ((class_591)this.method_17165()).field_3401, () -> SkinLayersModBase.config.enableRightSleeve));
        this.bodyLayers.add(new Layer(4, false, class_1664.field_7564, Shape.BODY, () -> ((class_591)this.method_17165()).field_3391, () -> SkinLayersModBase.config.enableJacket));
    }

    public void render(class_4587 poseStack, class_4597 multiBufferSource, int i, class_742 player, float f, float g, float h, float j, float k, float l) {
        if (!player.method_3127() || player.method_5767()) {
            return;
        }
        if (BodyLayerFeatureRenderer.mc.field_1687 == null) {
            return;
        }
        if (BodyLayerFeatureRenderer.mc.field_1724.method_5858((class_1297)player) > (double)(SkinLayersModBase.config.renderDistanceLOD * SkinLayersModBase.config.renderDistanceLOD)) {
            return;
        }
        PlayerSettings settings = (PlayerSettings)player;
        if (!SkinUtil.setup3dLayers(player, settings, this.thinArms, (class_591<class_742>)((class_591)this.method_17165()))) {
            return;
        }
        class_4588 vertexConsumer = multiBufferSource.getBuffer(class_1921.method_23689((class_2960)player.method_3117()));
        int m = class_922.method_23622((class_1309)player, (float)0.0f);
        this.renderLayers(player, settings.getSkinLayers(), poseStack, vertexConsumer, i, m);
    }

    public void renderLayers(class_742 abstractClientPlayer, CustomizableModelPart[] layers, class_4587 matrixStack, class_4588 vertices, int light, int overlay) {
        if (layers == null) {
            return;
        }
        float pixelScaling = SkinLayersModBase.config.baseVoxelSize;
        float heightScaling = 1.035f;
        float widthScaling = SkinLayersModBase.config.baseVoxelSize;
        boolean red = abstractClientPlayer.field_6235 > 0 || abstractClientPlayer.field_6213 > 0;
        float color = red ? 0.5f : 1.0f;
        for (Layer layer : this.bodyLayers) {
            if (!abstractClientPlayer.method_7348(layer.modelPart) || !layer.vanillaGetter.get().field_3665 || !layer.configGetter.get().booleanValue()) continue;
            matrixStack.method_22903();
            layer.vanillaGetter.get().method_22703(matrixStack);
            if (layer.shape == Shape.ARMS) {
                layers[layer.layersId].x = 0.998f;
            } else if (layer.shape == Shape.ARMS_SLIM) {
                layers[layer.layersId].x = 0.499f;
            }
            if (layer.shape == Shape.BODY) {
                widthScaling = SkinLayersModBase.config.bodyVoxelWidthSize;
            }
            if (layer.mirrored) {
                layers[layer.layersId].x *= -1.0f;
            }
            matrixStack.method_22905(widthScaling, heightScaling, pixelScaling);
            layers[layer.layersId].y = layer.shape.yOffsetMagicValue;
            layers[layer.layersId].render(matrixStack, vertices, light, overlay, 1.0f, color, color, 1.0f);
            matrixStack.method_22909();
        }
    }

    private record Layer(int layersId, boolean mirrored, class_1664 modelPart, Shape shape, Supplier<class_630> vanillaGetter, Supplier<Boolean> configGetter) {
    }

    private static enum Shape {
        HEAD(0.0f, new SolidPixelWrapper.Dimensions(8, 8, 8)),
        BODY(0.6f, new SolidPixelWrapper.Dimensions(8, 12, 4)),
        LEGS(-0.2f, new SolidPixelWrapper.Dimensions(4, 14, 4)),
        ARMS(0.4f, new SolidPixelWrapper.Dimensions(4, 14, 4)),
        ARMS_SLIM(0.4f, new SolidPixelWrapper.Dimensions(3, 14, 4));

        private final float yOffsetMagicValue;
        private final SolidPixelWrapper.Dimensions dimensions;

        private Shape(float yOffsetMagicValue, SolidPixelWrapper.Dimensions dimensions) {
            this.dimensions = dimensions;
            this.yOffsetMagicValue = yOffsetMagicValue;
        }
    }
}

